#Indoor Air Quality with BME680 sensor
#Sep 17, 2018 by tklua@wifiboy.org

#setup UART2:RXPin=2,TXPin=4,Baudrate=9600bps
uart = machine.UART(2, baudrate=9600, rx=2, tx=4)

#init BME680 to continous ouput
uart.write(b'\xa5\x55\x3f\x39\xa5\x56\x02\xfd')

wb.cls()
while True:
    r  = uart.read() # 3 sec update
    if r!=None:
        t = float(r[4]*256+r[5])/100.0
        h = float(r[6]*256+r[7])/100.0
        p = float(r[8]*65536+r[9]*256+r[10])/100.0
        aq = (r[11]&0xf)*256+r[12]
        gas = r[13]*1048576+r[14]*65536+r[15]*256+r[16]
        alt = r[17]*256+r[18]
        #output to terminal
        print(t, h, p, aq, gas, alt, (r[11]&0xf0)/16)
        #output to lcd
        wb.colors(0x00b8,0); wb.str("Tmp:", 0,10,2,2)
        wb.colors(0x00f8,0); wb.str("%2.2fC"%(t), 58,10,2,2)
        wb.colors(0xe003,0); wb.str("Hum:", 0,30,2,2)
        wb.colors(0xe007,0); wb.str("%2.2f%%"%(h), 58,30,2,2)
        wb.colors(0x1f00,0); wb.str("Pr:", 0,50,2,2)
        wb.colors(0x1f04,0); wb.str("%4.1fhP"%(p), 33,50,2,2)
        wb.colors(0xc0f7,0); wb.str("IAQ:", 0,70,2,2)
        wb.colors(0xe0ff,0); wb.str("%03d"%(aq), 50,70,2,2)
        wb.colors(0xef7b,0); wb.str("Gas:", 0,90,2,2)
        wb.colors(0x18c6,0); wb.str("%6d"%(gas), 50,90,2,2)
        wb.colors(0x1ff8,0); wb.str("Alt:", 0,110,2,2)
        wb.colors(0x1ffc,0); wb.str("%04dm"%(alt), 50,110,2,2)
        
        
        